	subroutine tar(n,k,id,nextra,rho,x)
c**********************************************************************
c
c  FORTRAN subroutine to generate realizations of length n from a 
c  threshold autoregressive model
c
c     x_{1,t} = 0.6 * x_{2,t-1} + eps_{1,t}  if x_{1,t-1} > 0 
c     x_{2,t} = 0.6 * x_{1,t-1} + eps_{2,t}  if x_{2,t-1} > 0
c
c  Input: n = an integer scalar containing length of desired 
c             realization.
c         k = an integer containing the number of components in
c             the vector time series (right now k must equal 2).
c         id = an integer containing the delay for the threshold 
c              variable.
c         nextra = integer scalar containing number of extra 
c                  observations to generate.
c         rho = double precision real scalar containing error
c               cross-correlation.
c
c  Output: x = a double precision matrix of dimension n x k containing
c              the desired realization.
c         
c
c  Subprograms called:
c
c  Written: 2/20/99 JLH
c  Modified: 3/8/99 JLH
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
	parameter (maxn = 1200, maxk = 5, maxp = 10)
	double precision eps(maxn,maxk),sigma(maxk,maxk)
	double precision x(maxn,maxk)
c
c  Generate white noise (error terms):
c
	call vwn(n,maxn,k,maxk,rho,sigma,eps)
c
	x(1:maxn,1:maxk) = eps(1:maxn,1:maxk)
c
c   Generate realization:
c
	do iobs = 2,n+nextra
		do its = 1,k
			itsr = 2
			if(its.eq.2) itsr = 1
			x(iobs,its) = eps(iobs,its)
			critx = x(iobs-id,its)
			if(critx.gt.0.0d0) then
				x(iobs,its) = x(iobs,its) + 0.60d0*x(iobs-1,itsr)
			endif
		enddo
	enddo
c
c   Return only the last n values of x
c
	do iobs = 1,n
	do its = 1,k
		x(iobs,its) = x(iobs+nextra,its)
	enddo
	enddo
c
	return
	end
